class V1::BaseController < ApplicationController
  class NotAuthenticated < Exception; end

  around_action :handle_exceptions

  private

  def handle_exceptions
    begin
      yield
    rescue ActionController::BadRequest,
        ActionController::ParameterMissing,
        ActiveRecord::RecordInvalid => e
      if e.respond_to?(:record) && e.record
        errors = {errors: e.record.errors.to_hash(true)}
        render error(422, nil, errors.merge(backtrace(e)))
      else
        render error(400, e.message)
      end
    rescue ActiveRecord::RecordNotFound => e
      render error(404, e.message || 'Not Found', backtrace(e))
    rescue Authorization::NotAuthenticated => e
      render error(401, e.message, backtrace(e))
    rescue Authorization::Forbidden => e
      render error(403, e.message, backtrace(e))
    end
  end

  def backtrace(e)
    Rails.env.development? || Rails.env.test? ? {backtrace: e.backtrace} : {}
  end

  # Canned Responses

  def ok
    { status: 200, json: {} }
  end

  def error(status, msg, extra={})
    { status: status, json: {status: status, error: msg}.merge(extra) }
  end
end
