class Account < ApplicationRecord
  belongs_to :user
  validates :uid, presence: true
  validates :provider, presence: true
  validates :email, presence: true, format: {with: /@/}
  validate :data_content

  def info
    Hashie::Mash.new(data['info'])
  end

  private

  def data_content
    if !data || !data.include?('info') || info.nil?
      errors.add(:data, 'missing expected authentication data')
    end
  end
end
