class Client < ApplicationRecord
  validates :name, presence: true

  attribute :ident, :string, default: -> { self.generate_ident }
  validates :ident, presence: true

  attribute :secret, :string, default: -> { self.generate_ident(32) }
  validates :secret, presence: true

  attribute :settings, :jsonb, default: {}
  validates_each :settings do |record, attr, value|
    record.errors.add(attr, 'must be a hash') unless value.is_a?(Hash)
  end

  # Virtual attributes within `settings`:
  attribute :backend, :boolean, default: false

  def backend
    !!settings['backend']
  end

  def backend=(value)
    # Updates through Admin panel will pass in one of the _Strings_ '1' or '0'. x_x
    value = value.to_i == 1 unless value == !!value
    settings['backend'] = value
  end

  def self.generate_ident(length = 10)
    SecureRandom.urlsafe_base64(length * 2).gsub(/[_\-]/, '')[0..length]
  end
end
