class V1::UserPresenter < V1::BasePresenter
  attributes :id, :roles, :settings

  def initialize(object, options={})
    @show_email = !!options.delete(:with_email)
    super(object, options)
  end

  attribute :email, if: ->{@show_email}
  attribute :email_new, if: ->{@show_email}
  attribute :email_token, if: ->{!Rails.env.production? && @show_email}

  # Account data attributes, mostly Twitch-specific
  def account
    @account ||= object.accounts.first
  end

  attributes :name, :display_name, :avatar
  def name
    account&.info&.name
  end

  def display_name
    return nil if !account
    account.info.extra&.raw_info&.display_name ||
      account.info.nickname ||
      name
  end

  def avatar
    account&.info&.image
  end

  def diff
    object.previous_changes
  end
  attribute :diff, if: -> { diff.present? }
end
