Rails.application.routes.draw do
  api_version(module: 'V1', path: {value: 'v1'}) do
    resources :clients
    resources :tokens
    resources :users do
      collection do
        get 'verify/:email_token', to: 'users#verify_email'
        get 'verify', to: 'users#verify_email'
      end
    end
  end

  namespace :admin do
    resources :users do
      member do
        put :verify_email
      end
    end
    resources :accounts
    resources :tokens
    resources :clients

    root to: "users#index"
  end

  get '/auth/:provider/callback', to: 'omniauth_callbacks#callback'
  get '/auth/:provider/setup', to: 'omniauth_callbacks#setup'

  get '/health', to: 'application#health'

  get '*missing', to: 'application#missing'
  post '*missing', to: 'application#missing'
  root to: 'application#health'
end
