class MakeUserEmailNullable < ActiveRecord::Migration[5.0]
  def up
    change_column_null :users, :email, true
  end

  def down
    Users.all.each do |user|
      if user.email.nil?
        account = Account.find_by!(user_id: user.id)
        user.update!(email: account.data.dig('info', 'email'))
      end
    end
    change_column_null :users, :email, false
  end
end
