class AddEmailToAccounts < ActiveRecord::Migration[5.0]
  def up
    add_column :accounts, :email, :string, default: 'foo@example.com'
    Account.all.each do |account|
      account.update!(email: account.info.email)
    end
    change_column_default :accounts, :email, nil
    change_column_null :accounts, :email, false
  end

  def down
    remove_column :accounts, :email
  end
end
