# TODO this is being run by bin/update on every container start. That's
# obviously a terrible idea to do down the road, or at all really.
#
# Make sure this eventually only does very specific things and/or move it
# out of bin/update.
#
# Note that this uses delete, which issues a simple DELETE query. So no
# dependant associations are destroyed or callbacks triggered.. on purpose.
namespace :db do
  desc "Clean up database, remove stray invalid objects"
  task clean: :environment do
    [Account].each do |model|
      model.all.each do |obj|
        if !obj.valid?
          puts "Deleting #{model} (id = #{obj.id}) because it is invalid (#{obj.errors.inspect})"
          obj.delete
        end
      end
    end
  end
end
