require 'rails_helper'

describe V1::BaseController do
  describe '#handle_exception' do
    {
      ActionController::BadRequest => 400,
      ActionController::ParameterMissing => 400,
      ActiveRecord::RecordInvalid => 422,
      ActiveRecord::RecordNotFound => 404,
      Authorization::NotAuthenticated => 401,
      Authorization::Forbidden => 403
    }.each do |klass, http_status|
      it "should rescue from #{klass} and render a #{http_status} response" do
        response = controller.response = ActionDispatch::TestResponse.new
        expect do
          controller.instance_eval <<-EOF
            handle_exceptions do
              case #{http_status}
              when 422
                raise #{klass}.new(User.new)
              else
                raise #{klass}.new(:testing)
              end
            end
          EOF
        end.to_not raise_error
        json = JSON.parse(response.body)
        expect(response.status).to eq(http_status)
        expect(json['status']).to eq(http_status)
      end
    end
  end
end
