FactoryGirl.define do
  factory :account do
    provider 'twitch'
    uid { rand * 666 * 666 }
    sequence :email do |n| "account#{n}@example.com" end
    association :user
    sequence :data do |n|
      { info: {
        name: "tester-#{n}",
        image: 'avatar.jpg',
        email: email
      }}
    end
  end

  factory :client do
    sequence :name do |n| "client-#{n}" end
    twitch_client_id { SecureRandom.hex(30) }
    twitch_client_secret { SecureRandom.hex(30) }
    settings Hash.new
  end

  factory :token do
    token { SecureRandom.hex(64) }
    association :user
  end

  factory :user do
    email_new   { SecureRandom.hex(8) + '@example.com' }
    email_token { SecureRandom.hex(16) }

    trait :with_account do
      after(:create) do |user|
        create_list(:account, 1, user: user)
      end
    end

    trait :with_verified_email do
      after(:create) {|user| user.verify_email!}
    end

    factory :user_with_account, traits: [:with_account]
    factory :user_with_verified_email, traits: [:with_verified_email]
  end
end
