require "rails_helper"

RSpec.describe UserMailer, type: :mailer do
  before :each do
    @mailer = UserMailer.new
  end

  describe 'sends verification emails' do
    it "to a user's original email address" do
      user = FactoryGirl.create(:user_with_verified_email)
      user.email_new = 'wrong'
      expect(@mailer).to receive(:mail).with(hash_including(to: user.email))
      @mailer.verify_email(user)
    end

    it "to a user's new address if they don't have a current verified address" do
      user = FactoryGirl.create(:user)
      expect(user.email).to be_nil
      expect(@mailer).to receive(:mail).with(hash_including(to: user.email_new))
      @mailer.verify_email(user)
    end
  end
end
