require 'rails_helper'

RSpec.describe Account, :type => :model do
  describe 'validations' do
    it 'requires at least an info hash in data' do
      account = Account.new(data: {nop: true})
      expect(account).to be_invalid
      expect(account.errors).to include(:data)
    end

    it 'requires a provider' do
      account = FactoryGirl.build(:account)
      expect(account).to be_valid
      account.provider = nil
      expect(account).to be_invalid
      expect(account.errors).to include(:provider)
    end

    it 'requires a uid' do
      account = FactoryGirl.build(:account)
      expect(account).to be_valid
      account.uid = nil
      expect(account).to be_invalid
    end
  end
end
