require 'rails_helper'

RSpec.describe Client, type: :model do
  describe 'settings' do
    it 'should always be a hash' do
      c = FactoryGirl.build(:client, settings: 'not a hash')
      expect(c.valid?).to eq(false)
      expect(c.errors).to include(:settings)
      expect(c.errors[:settings]).to include('must be a hash')
    end

    it 'should always store settings["backend"] as a boolean' do
      c = FactoryGirl.build(:client)
      expect(c.backend).to eq(false)
      {true => [1, '1', true], false => [nil, 0, '0', false]}.each do |exp, vals|
        vals.each do |val|
          c.backend = val
          expect(c.valid?).to eq(true)
          expect(c.backend).to eq(exp)
        end
      end
    end
  end
end
