require 'rails_helper'

RSpec.describe Token, type: :model do
  before :each do
  end

  it 'should only require a token' do
    token = Token.new
    expect { token.save! }.to raise_error
    token.token = 'test'
    expect { token.save! }.to_not raise_error
  end

  describe '#to_s' do
    it 'should return #token' do
      token = FactoryGirl.create(:token)
      expect(token.to_s).to eq(token.token)
    end
  end
end
