require 'rails_helper'

RSpec.describe OmniauthCallbacksController, :type => :request do
  include Features::Authentication

  describe '#setup' do
    around :each do |test|
      stub_oauth_login { test.run }
    end

    it 'should require the Client-ID header' do
      get '/auth/developer/setup'
      expect(response.status).to eq(401), response.body
      expect(json['error']).to match(/Missing Client-ID/i)
    end

    it 'should not use the client_id param as the client' do
      get '/auth/developer/setup',
        params: {client_id: FactoryGirl.create(:client).ident}
      expect(response.status).to eq(401), response.body
      expect(json['error']).to match(/Missing Client-ID/i)
    end

    it 'should reply with 404 for invalid clients' do
      get '/auth/developer/setup',
        headers: {'Client-ID' => Client.generate_ident}
      expect(response.status).to eq(404), response.body
      expect(json['error']).to match(/No such Client/i)
    end
  end
end
