require 'rails_helper'

describe V1::ClientsController, type: :request do
  describe '#show' do
    before :each do
      @client_id = Client.count == 0 ? 1 : Client.order('id DESC').first.id + 1
    end

    it 'looks up based on ident first' do
      @client1 = FactoryGirl.create(:client, ident: @client_id.to_s, id: @client_id+10)
      @client2 = FactoryGirl.create(:client, id: @client_id)
      get "/v1/clients/#{@client_id}"
      expect(response.status).to eq(200)
      expect(json['id']).to eq(@client1.id)
      expect(json['ident']).to eq(@client1.ident)
    end

    it "backs off to using client.id if it's an integer and ident lookup failed" do
      @client1 = FactoryGirl.create(:client, ident: 'foo', id: @client_id)
      get "/v1/clients/#{@client_id}"
      expect(response.status).to eq(200)
      expect(json['id']).to eq(@client1.id)
      expect(json['ident']).to eq(@client1.ident)
    end

    it "does not try to look up by id if it's not an integer" do
      @client = FactoryGirl.create(:client, id: @client_id, ident: @client_id)
      get "/v1/clients/#{@client_id}abc"
      expect(response.status).to eq(404)
    end
  end
end
