require 'rails_helper'

describe V1::TokensController, type: :request do
  describe '#show' do
    before :each do
      @token = FactoryGirl.create(:token)
      @headers = {'Token': @token.token}
    end

    it 'should include the user in the reply' do
      get "/v1/tokens/#{@token.token}", headers: @headers
      expect(response.status).to eq(200), ->{pp json}
      expect(json.keys).to include('user'), ->{pp json}
    end

    it 'should only render the token if it has a valid user' do
      @token.update_attribute(:user_id, nil)
      get "/v1/tokens/#{@token.token}", headers: @headers
      expect(response.status).to eq(404), ->{pp json}
    end

    it 'returns the requested token' do
      get "/v1/tokens/#{@token.token}", headers: @headers
      expect(response.status).to eq(200)
      expect(json['token']).to eq(@token.token)
    end

    it 'returns a 404 for non-existent tokens' do
      get '/v1/tokens/does-not-exist', headers: @headers
      expect(response.status).to eq(404)
    end
  end
end
