module Features
  module Authentication
    def stub_oauth_login(provider: :twitch)
      auth_hash = OmniAuth::AuthHash.new(
        provider: provider,
        uid: Random.rand(1234),
        info: {
          nickname: 'fyrn',
          email: 'marian@twitch.tv'
        }
      )

      provider = auth_hash.provider.to_sym

      OmniAuth.config.mock_auth[provider] = auth_hash
      yield auth_hash
      OmniAuth.config.mock_auth[provider] = nil
    end
  end
end
