data "aws_alb" "service" {
  name = "${var.service_name}"
  depends_on = ["module.service"]
}

module "alarms" {
  source = "git::ssh://git@git-aws.internal.justin.tv/esports/terraform.git//modules/alarms?ref=2017-05-18"

  name_prefix = "${var.service_name}_${var.service_env}"
  service_name = "${var.service_name}"

  alb_4XX = true
  alb_4XX_threshold = "20"
  alb_5XX = true
  alb_5XX_threshold = "20"
  alb_arn_suffix = "${data.aws_alb.service.arn_suffix}"

  insufficient_data_actions = []
  alarm_actions = ["${data.terraform_remote_state.aws.alarm_sns_topic_arn}"]
  ok_actions = ["${data.terraform_remote_state.aws.alarm_sns_topic_arn}"]
}
