export interface Action<T, P> {
    readonly type: T;
    readonly payload: P;
    readonly meta?: any;
}
export declare function createErrorAction(error: any): Action<'ERROR', any>;
export declare const API_FETCH = "API_FETCH";
export declare const API_FETCH_DONE = "API_FETCH_DONE";
export interface ApiFetchAction extends Action<typeof API_FETCH, any> {
}
export interface ApiFetchDoneAction extends Action<typeof API_FETCH_DONE, any> {
}
export * from './actions/user';
export * from './actions/team';
export * from './actions/teamInvitation';
export * from './actions/tournament';
export * from './actions/tournamentEntry';
export * from './actions/game';
export * from './actions/match';
export * from './actions/series';
export * from './actions/article';
export * from './actions/season';
