import { Action } from '../actions';
import { UserModel } from '../models';
export declare const UPDATE_USERS = "UPDATE_USERS";
export declare const AUTH_USER = "AUTH_USER";
export declare const LOGOUT_USER = "LOGOUT_USER";
export interface UpdateUsersAction extends Action<typeof UPDATE_USERS, UserModel[]> {
}
export interface AuthUserAction extends Action<typeof AUTH_USER, UserModel> {
}
export interface LogoutAction extends Action<typeof LOGOUT_USER, undefined> {
}
export declare function createUpdateUsersAction(users: UserModel[]): UpdateUsersAction;
export declare function createAuthUserAction(user: UserModel): AuthUserAction;
export declare function createLogoutAction(): LogoutAction;
export declare type All = UpdateUsersAction | AuthUserAction | LogoutAction;
