"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fetch = require("isomorphic-fetch");
var actions = require("../actions");
var config_1 = require("../config");
var index_1 = require("./index");
// TODO thenable this?
// I haven't figured out a good way to extend Promise/Thenable.
var APIAction = (function () {
    function APIAction(options) {
        if (options === void 0) { options = {}; }
        var _this = this;
        this.handler = options.handler;
        this.request = options.request;
        this.promise = new Promise(function (resolve, reject) {
            _this.resolve = resolve;
            _this.reject = reject;
        });
    }
    APIAction.prototype.fetch = function () {
        var _this = this;
        this.request.options.headers = Object.assign({
            'Client-ID': config_1.config.apiClientId,
            Authorization: config_1.config.authToken ? 'Bearer ' + config_1.config.authToken : ''
        }, this.request.options.headers);
        return fetch(this.request.url, this.request.options)
            .then(function (response) {
            switch (response.status) {
                case 401: return _this.handler.dispatch(index_1.authUser());
                case 204: return { status: 204 };
                default: return response.json();
            }
        })
            .then(function (json) {
            // TODO instead of dispatching via action.promise.then in async
            // creators, resolve w/ the actual action and set the meta on it.
            _this.handler.dispatch({
                type: actions.API_FETCH_DONE,
                payload: json,
                meta: {
                    fetch: {
                        url: _this.request.url,
                        done: true
                    }
                }
            });
            // TODO
            // We resolve APIAction.promise with the raw json and the returned
            // promise (chaining on an async action creator) with just data, as
            // that is what they currently use for the most part.
            switch (json.status) {
                case 204:
                case 302:
                case 200:
                    _this.resolve(json);
                    return Promise.resolve(json.data);
                default:
                    return Promise.reject(json);
            }
        }).catch(function (e) {
            _this.reject(e);
            return Promise.reject(e);
        });
    };
    return APIAction;
}());
exports.APIAction = APIAction;
//# sourceMappingURL=action.js.map