"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Actions = require("../actions");
var api_1 = require("../api");
var config_1 = require("../config");
function createOrUpdateArticle(article) {
    return (article.id && article.id !== '')
        ? updateArticle(article)
        : createArticle(article);
}
exports.createOrUpdateArticle = createOrUpdateArticle;
function createArticle(article) {
    var formData = api_1.createFormData(article);
    var request = {
        url: config_1.config.apiUrl + "/v1/articles",
        options: {
            headers: {},
            method: 'POST',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateArticlesAction([json.data]));
        });
        return action;
    };
}
exports.createArticle = createArticle;
function updateArticle(article) {
    var formData = api_1.createFormData(article);
    var request = {
        url: config_1.config.apiUrl + "/v1/articles/" + article.id,
        options: {
            headers: {},
            method: 'PATCH',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateArticlesAction([json.data]));
        });
        return action;
    };
}
exports.updateArticle = updateArticle;
function publishArticle(article) {
    var formData = api_1.createFormData({
        id: article.id,
        state: 'final'
    });
    var request = {
        url: config_1.config.apiUrl + "/v1/articles/" + article.id,
        options: {
            headers: {},
            method: 'PATCH',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateArticlesAction([json.data]));
        });
        return action;
    };
}
exports.publishArticle = publishArticle;
function getArticles(params) {
    if (params === void 0) { params = {}; }
    var request = {
        url: config_1.config.apiUrl + "/v1/articles",
        options: {
            method: 'GET'
        },
        params: params
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateArticlesAction(json.data));
        });
        return action;
    };
}
exports.getArticles = getArticles;
function getArticle(articleId) {
    var request = {
        url: config_1.config.apiUrl + "/v1/articles/" + articleId,
        options: {
            method: 'GET'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateArticlesAction([json.data]));
        });
        return action;
    };
}
exports.getArticle = getArticle;
function deleteArticle(articleId) {
    var request = {
        url: config_1.config.apiUrl + "/v1/articles/" + articleId,
        options: {
            method: 'DELETE'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createDeleteArticleAction(json.data));
        });
        return action;
    };
}
exports.deleteArticle = deleteArticle;
//# sourceMappingURL=article.js.map