"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Actions = require("../actions");
var api_1 = require("../api");
var config_1 = require("../config");
function createOrUpdateEvent(event) {
    return (event.id && event.id !== '')
        ? updateEvent(event)
        : createEvent(event);
}
exports.createOrUpdateEvent = createOrUpdateEvent;
function createEvent(event) {
    var formData = api_1.createFormData(event);
    var request = {
        url: config_1.config.apiUrl + "/v1/events",
        options: {
            headers: {},
            method: 'POST',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateEventsAction([json.data]));
        });
        return action;
    };
}
exports.createEvent = createEvent;
function updateEvent(event) {
    var formData = api_1.createFormData(event);
    var request = {
        url: config_1.config.apiUrl + "/v1/events/" + event.id,
        options: {
            headers: {},
            method: 'PATCH',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateEventsAction([json.data]));
        });
        return action;
    };
}
exports.updateEvent = updateEvent;
function getEvents(params) {
    if (params === void 0) { params = {}; }
    var request = {
        url: config_1.config.apiUrl + "/v1/events",
        options: {
            method: 'GET'
        },
        params: params
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateEventsAction(json.data));
        });
        return action;
    };
}
exports.getEvents = getEvents;
function getEvent(eventId) {
    var request = {
        url: config_1.config.apiUrl + "/v1/events/" + eventId,
        options: {
            method: 'GET'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateEventsAction([json.data]));
        }).catch(function (e) {
            dispatch(Actions.createErrorAction(e));
        });
        return action;
    };
}
exports.getEvent = getEvent;
function deleteEvent(eventId) {
    var request = {
        url: config_1.config.apiUrl + "/v1/events/" + eventId,
        options: {
            method: 'DELETE'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createDeleteEventAction(json.data));
        });
        return action;
    };
}
exports.deleteEvent = deleteEvent;
//# sourceMappingURL=event.js.map