"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Actions = require("../actions");
var api_1 = require("../api");
var config_1 = require("../config");
function createOrUpdateGame(game) {
    return (game.id && game.id !== '')
        ? updateGame(game)
        : createGame(game);
}
exports.createOrUpdateGame = createOrUpdateGame;
function createGame(game) {
    var formData = api_1.createFormData(game);
    var request = {
        url: config_1.config.apiUrl + "/v1/games",
        options: {
            headers: {},
            method: 'POST',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateGamesAction([json.data]));
        });
        return action;
    };
}
exports.createGame = createGame;
function updateGame(game) {
    var formData = api_1.createFormData(game);
    var request = {
        url: config_1.config.apiUrl + "/v1/games/" + game.id,
        options: {
            headers: {},
            method: 'PATCH',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateGamesAction([json.data]));
        });
        return action;
    };
}
exports.updateGame = updateGame;
function getGames(params) {
    if (params === void 0) { params = {}; }
    var request = {
        url: config_1.config.apiUrl + "/v1/games",
        options: {
            method: 'GET'
        },
        params: params
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateGamesAction(json.data));
        });
        return action;
    };
}
exports.getGames = getGames;
function getGame(gameId) {
    var request = {
        url: config_1.config.apiUrl + "/v1/games/" + gameId,
        options: {
            method: 'GET'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateGamesAction([json.data]));
        }).catch(function (e) {
            dispatch(Actions.createErrorAction(e));
        });
        return action;
    };
}
exports.getGame = getGame;
//# sourceMappingURL=game.js.map