import { APIAction } from './action';
export interface APIParams {
    [key: string]: any;
}
export interface APIRequestOptions {
    query?: Object;
    method?: string;
    body?: string | FormData;
    headers?: Object;
}
export interface APIRequest {
    url: string;
    options?: APIRequestOptions;
    params?: any;
    object?: any;
}
export interface APIActionSet {
    pre?: Function;
    success?: Function;
    redirected?: Function;
    error?: Function;
}
export declare class APIHandler {
    dispatch: Function;
    constructor(dispatch: any);
    call(request: APIRequest, actionSet: APIActionSet): APIAction;
}
export declare function decycle(object: any): any;
export declare function createFormData(object: any, form?: FormData, namespace?: string): FormData;
export * from './action';
export * from './user';
export * from './team';
export * from './teamInvitation';
export * from './tournament';
export * from './tournamentEntry';
export * from './game';
export * from './match';
export * from './series';
export * from './article';
export * from './images';
export * from './season';
export * from './event';
