"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
var stringify = require("json-stringify-safe");
var action_1 = require("./action");
var APIHandler = (function () {
    function APIHandler(dispatch) {
        this.dispatch = dispatch;
    }
    APIHandler.prototype.call = function (request, actionSet) {
        request.options = Object.assign({
            headers: {
                'Content-Type': 'application/json',
                Accept: 'application/js'
            }
        }, request.options);
        if (request.params) {
            var params_1 = decycle(request.params);
            var query = Object.keys(params_1)
                .map(function (k) {
                if (params_1[k] !== '') {
                    return [encodeURIComponent(k), encodeURIComponent(params_1[k])].join('=');
                }
            })
                .filter(function (q) { return q !== undefined; })
                .join('&');
            if (query.length > 0) {
                request.url += '?' + query;
            }
        }
        if (request.object) {
            request.options.body = JSON.stringify(decycle(request.object));
        }
        if (typeof actionSet.pre === 'function') {
            this.dispatch(actionSet.pre());
        }
        return new action_1.APIAction({
            handler: this,
            request: request
        });
    };
    return APIHandler;
}());
exports.APIHandler = APIHandler;
function decycle(object) {
    return JSON.parse(stringify(object, undefined, 2, function () { return ''; }));
}
exports.decycle = decycle;
function createFormData(object, form, namespace) {
    var formData = form || new FormData();
    var _loop_1 = function (property) {
        if (!object.hasOwnProperty(property) || !object[property]) {
            return "continue";
        }
        var formKey = namespace ? namespace + "[" + property + "]" : property;
        if (object[property] instanceof Date) {
            formData.append(formKey, object[property].toISOString());
        }
        else if (typeof object[property] === 'object' && Array.isArray(object[property])) {
            // send empty array if necessary
            if (object[property].length === 0) {
                formData.append(property, '');
            }
            object[property].forEach(function (obj) {
                formData.append(property + "[]", obj);
            });
        }
        else if (typeof object[property] === 'object' && !(object[property] instanceof File)) {
            createFormData(decycle(object[property]), formData, formKey);
        }
        else {
            formData.append(formKey, object[property]);
        }
    };
    for (var property in object) {
        _loop_1(property);
    }
    return formData;
}
exports.createFormData = createFormData;
__export(require("./action"));
__export(require("./user"));
__export(require("./team"));
__export(require("./teamInvitation"));
__export(require("./tournament"));
__export(require("./tournamentEntry"));
__export(require("./game"));
__export(require("./match"));
__export(require("./series"));
__export(require("./article"));
__export(require("./images"));
__export(require("./season"));
__export(require("./event"));
//# sourceMappingURL=index.js.map