"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Actions = require("../actions");
var api_1 = require("../api");
var config_1 = require("../config");
function createOrUpdateMatch(match) {
    return (match.id && match.id !== '')
        ? updateMatch(match)
        : createMatch(match);
}
exports.createOrUpdateMatch = createOrUpdateMatch;
function createMatch(match) {
    var request = {
        url: config_1.config.apiUrl + "/v1/matches",
        options: {
            method: 'POST'
        },
        object: match
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateMatchesAction([json.data]));
        });
        return action;
    };
}
exports.createMatch = createMatch;
function updateMatch(match) {
    var request = {
        url: config_1.config.apiUrl + "/v1/matches/" + match.id,
        options: {
            method: 'PATCH'
        },
        object: match
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateMatchesAction([json.data]));
        });
        return action;
    };
}
exports.updateMatch = updateMatch;
function getMatches(params) {
    if (params === void 0) { params = {}; }
    var request = {
        url: config_1.config.apiUrl + "/v1/matches",
        options: {
            method: 'GET'
        },
        params: params
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateMatchesAction(json.data));
        });
        return action;
    };
}
exports.getMatches = getMatches;
//# sourceMappingURL=match.js.map