"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Actions = require("../actions");
var api_1 = require("../api");
var config_1 = require("../config");
function createOrUpdateSeason(season) {
    return (season.id && season.id !== '')
        ? updateSeason(season)
        : createSeason(season);
}
exports.createOrUpdateSeason = createOrUpdateSeason;
function createSeason(season) {
    var formData = api_1.createFormData(season);
    var request = {
        url: config_1.config.apiUrl + "/v1/seasons",
        options: {
            headers: {},
            method: 'POST',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateSeasonsAction([json.data]));
        });
        return action;
    };
}
exports.createSeason = createSeason;
function updateSeason(season) {
    var formData = api_1.createFormData(season);
    var request = {
        url: config_1.config.apiUrl + "/v1/seasons/" + season.id,
        options: {
            headers: {},
            method: 'PATCH',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateSeasonsAction([json.data]));
        });
        return action;
    };
}
exports.updateSeason = updateSeason;
function getSeasons(params) {
    if (params === void 0) { params = {}; }
    var request = {
        url: config_1.config.apiUrl + "/v1/seasons",
        options: {
            method: 'GET'
        },
        params: params
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateSeasonsAction(json.data));
        });
        return action;
    };
}
exports.getSeasons = getSeasons;
function getSeason(seasonId) {
    var request = {
        url: config_1.config.apiUrl + "/v1/seasons/" + seasonId,
        options: {
            method: 'GET'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateSeasonsAction([json.data]));
        }).catch(function (e) {
            dispatch(Actions.createErrorAction(e));
        });
        return action;
    };
}
exports.getSeason = getSeason;
//# sourceMappingURL=season.js.map