"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Actions = require("../actions");
var api_1 = require("../api");
var config_1 = require("../config");
function createOrUpdateSeries(series) {
    return (series.id && series.id !== '')
        ? updateSeries(series)
        : createSeries(series);
}
exports.createOrUpdateSeries = createOrUpdateSeries;
function createSeries(series) {
    var request = {
        url: config_1.config.apiUrl + "/v1/series",
        options: {
            method: 'POST'
        },
        object: series
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateSeriesAction([json.data]));
        });
        return action;
    };
}
exports.createSeries = createSeries;
function updateSeries(series) {
    var request = {
        url: config_1.config.apiUrl + "/v1/series/" + series.id,
        options: {
            method: 'PATCH'
        },
        object: series
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateSeriesAction([json.data]));
        });
        return action;
    };
}
exports.updateSeries = updateSeries;
function getSeries(params) {
    if (params === void 0) { params = {}; }
    var request = {
        url: config_1.config.apiUrl + "/v1/series",
        options: {
            method: 'GET'
        },
        params: params
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateSeriesAction(json.data));
        });
        return action;
    };
}
exports.getSeries = getSeries;
//# sourceMappingURL=series.js.map