"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var TeamActions = require("../actions/team");
var api_1 = require("../api");
var config_1 = require("../config");
function createOrUpdateTeam(team) {
    return (team.id && team.id !== '')
        ? updateTeam(team)
        : createTeam(team);
}
exports.createOrUpdateTeam = createOrUpdateTeam;
function updateTeam(team) {
    var formData = api_1.createFormData(team);
    var request = {
        url: config_1.config.apiUrl + "/v1/teams/" + team.id,
        options: {
            headers: {},
            method: 'PATCH',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TeamActions.createUpdateTeamsAction([json.data]));
        });
        return action;
    };
}
exports.updateTeam = updateTeam;
function createTeam(team) {
    var formData = api_1.createFormData(team);
    var request = {
        url: config_1.config.apiUrl + "/v1/teams",
        options: {
            headers: {},
            method: 'POST',
            body: formData
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TeamActions.createUpdateTeamsAction([json.data]));
        });
        return action;
    };
}
exports.createTeam = createTeam;
function getTeam(id) {
    var request = {
        url: config_1.config.apiUrl + "/v1/teams/" + id,
        options: {
            method: 'GET'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TeamActions.createUpdateTeamsAction([json.data]));
        });
        return action;
    };
}
exports.getTeam = getTeam;
function getTeams(params) {
    if (params === void 0) { params = {}; }
    var request = {
        url: config_1.config.apiUrl + "/v1/teams",
        options: {
            method: 'GET'
        },
        params: params
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TeamActions.createUpdateTeamsAction(json.data));
        });
        return action;
    };
}
exports.getTeams = getTeams;
function deleteTeamUser(teamId, userId) {
    var request = {
        url: config_1.config.apiUrl + "/v1/teams/" + teamId + "/users/" + userId,
        options: {
            method: 'DELETE'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TeamActions.createUpdateTeamsAction([json.data]));
        });
        return action;
    };
}
exports.deleteTeamUser = deleteTeamUser;
//# sourceMappingURL=team.js.map