"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var team_1 = require("../actions/team");
var TeamInvitationActions = require("../actions/teamInvitation");
var api_1 = require("../api");
var config_1 = require("../config");
function acceptTeamInvitation(token) {
    var request = {
        url: config_1.config.apiUrl + "/v1/team_invitations/" + token + "/accept",
        options: {
            method: 'PATCH'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            // accept returns the updated team
            dispatch(team_1.createUpdateTeamsAction([json.data]));
        });
        return action;
    };
}
exports.acceptTeamInvitation = acceptTeamInvitation;
function createTeamInvitation(teamInvitation) {
    var request = {
        url: config_1.config.apiUrl + "/v1/team_invitations",
        options: {
            method: 'POST'
        },
        object: teamInvitation
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TeamInvitationActions.createUpdateTeamInvitationsAction([json.data]));
        });
        return action;
    };
}
exports.createTeamInvitation = createTeamInvitation;
function deleteTeamInvitation(id) {
    var request = {
        url: config_1.config.apiUrl + "/v1/team_invitations/" + id,
        options: {
            method: 'DELETE'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TeamInvitationActions.createDeleteTeamInvitationsAction([json.data]));
        });
        return action;
    };
}
exports.deleteTeamInvitation = deleteTeamInvitation;
//# sourceMappingURL=teamInvitation.js.map