"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Actions = require("../actions");
var api_1 = require("../api");
var config_1 = require("../config");
function createOrUpdateTournament(tournament) {
    return (tournament.id && tournament.id !== '')
        ? updateTournament(tournament)
        : createTournament(tournament);
}
exports.createOrUpdateTournament = createOrUpdateTournament;
function createTournament(tournament) {
    var request = {
        url: config_1.config.apiUrl + "/v1/tournaments",
        options: {
            method: 'POST'
        },
        object: tournament
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateTournamentsAction([json.data]));
        });
        return action;
    };
}
exports.createTournament = createTournament;
function updateTournament(tournament) {
    var request = {
        url: config_1.config.apiUrl + "/v1/tournaments/" + tournament.id,
        options: {
            method: 'PATCH'
        },
        object: tournament
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateTournamentsAction([json.data]));
        });
        return action;
    };
}
exports.updateTournament = updateTournament;
function getTournaments(params) {
    if (params === void 0) { params = {}; }
    var request = {
        url: config_1.config.apiUrl + "/v1/tournaments",
        options: {
            method: 'GET'
        },
        params: params
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateTournamentsAction(json.data));
        });
        return action;
    };
}
exports.getTournaments = getTournaments;
function getTournament(tournamentId) {
    var request = {
        url: config_1.config.apiUrl + "/v1/tournaments/" + tournamentId,
        options: {
            method: 'GET'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(Actions.createUpdateTournamentsAction([json.data]));
        }).catch(function (e) {
            dispatch(Actions.createErrorAction(e));
        });
        return action;
    };
}
exports.getTournament = getTournament;
//# sourceMappingURL=tournament.js.map