"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var TournamentEntryActions = require("../actions/tournamentEntry");
var api_1 = require("../api");
var config_1 = require("../config");
function deleteTournamentEntry(tournamentEntry) {
    var request = {
        url: config_1.config.apiUrl + "/v1/tournament_entries/" + tournamentEntry.id,
        options: {
            method: 'DELETE'
        }
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TournamentEntryActions.createDeleteTournamentEntriesAction([json.data]));
        });
        return action;
    };
}
exports.deleteTournamentEntry = deleteTournamentEntry;
function createOrUpdateTournamentEntry(tournamentEntry) {
    return (tournamentEntry.id && tournamentEntry.id !== '')
        ? updateTournamentEntry(tournamentEntry)
        : createTournamentEntry(tournamentEntry);
}
exports.createOrUpdateTournamentEntry = createOrUpdateTournamentEntry;
function updateTournamentEntry(tournamentEntry) {
    var request = {
        url: config_1.config.apiUrl + "/v1/tournament_entries/" + tournamentEntry.id,
        options: {
            method: 'PATCH'
        },
        object: tournamentEntry
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TournamentEntryActions.createUpdateTournamentEntriesAction([json.data]));
        });
        return action;
    };
}
exports.updateTournamentEntry = updateTournamentEntry;
function createTournamentEntry(tournamentEntry) {
    var request = {
        url: config_1.config.apiUrl + "/v1/tournament_entries",
        options: {
            method: 'POST'
        },
        object: tournamentEntry
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TournamentEntryActions.createUpdateTournamentEntriesAction([json.data]));
        });
        return action;
    };
}
exports.createTournamentEntry = createTournamentEntry;
function getTournamentEntries(params) {
    if (params === void 0) { params = {}; }
    var request = {
        url: config_1.config.apiUrl + "/v1/tournament_entries",
        options: {
            method: 'GET'
        },
        params: params
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(TournamentEntryActions.createUpdateTournamentEntriesAction(json.data));
        });
        return action;
    };
}
exports.getTournamentEntries = getTournamentEntries;
//# sourceMappingURL=tournamentEntry.js.map