"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var UserActions = require("../actions/user");
var api_1 = require("../api");
var config_1 = require("../config");
function getUsers() {
    var request = {
        url: config_1.config.apiUrl + '/v1/users'
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(UserActions.createUpdateUsersAction(json.data));
        });
        return action;
    };
}
exports.getUsers = getUsers;
function getUser(id) {
    var request = {
        url: config_1.config.apiUrl + "/v1/users/" + id
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(UserActions.createUpdateUsersAction([json.data]));
        });
        return action;
    };
}
exports.getUser = getUser;
// Handles all user authentication and should probably be broken up
//
// When given a token and a code, it will generate an async action that simply
// passes on an OAuth2 callback.
//
// When not given any arguments, it will generate an async action that
// initiates an OAuth2 request and redirects to the provider.
function authUser(token, code, redirect) {
    if (token === void 0) { token = ''; }
    if (code === void 0) { code = ''; }
    if (redirect === void 0) { redirect = true; }
    var request;
    var actions = {};
    if (token === '' || code === '') {
        request = {
            url: config_1.config.apiUrl + '/v1/users/auth'
        };
    }
    else {
        request = {
            url: config_1.config.apiUrl + '/v1/users/auth/callback/twitch'
        };
        request.params = {
            token: token,
            code: code
        };
    }
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            if (request.params && request.params.token) {
                localStorage.setItem('token', request.params.token);
            }
            if (json.status === 302 && redirect) {
                window.location.href = json.redirect;
                return json;
            }
            else if (json.data) {
                dispatch(UserActions.createAuthUserAction(json.data));
            }
        });
        return action;
    };
}
exports.authUser = authUser;
function updateUser(user) {
    var request = {
        url: config_1.config.apiUrl + '/v1/users/' + user.id,
        options: {
            method: 'PUT'
        },
        object: user
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(UserActions.createUpdateUsersAction([json.data]));
        });
        return action;
    };
}
exports.updateUser = updateUser;
function verifyEmailToken(token) {
    var request = {
        url: config_1.config.apiUrl + '/v1/users/verify/' + token
    };
    var actions = {};
    return function (dispatch) {
        var api = new api_1.APIHandler(dispatch);
        var action = api.call(request, actions);
        action.promise.then(function (json) {
            dispatch(UserActions.createUpdateUsersAction([json.data]));
        });
        return action;
    };
}
exports.verifyEmailToken = verifyEmailToken;
function logoutUser() {
    return function (dispatch) {
        localStorage.removeItem('token');
        dispatch(UserActions.createLogoutAction());
        return Promise.resolve();
    };
}
exports.logoutUser = logoutUser;
//# sourceMappingURL=user.js.map