"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var api_1 = require("./api");
exports.middleware = [function (store) { return function (next) { return function (action) {
        if (typeof action === 'function') {
            var apiAction = action(store.dispatch, store.getState);
            if (apiAction instanceof api_1.APIAction) {
                var requests = store.getState().tourney.requests;
                if (requests[apiAction.request.url] && requests[apiAction.request.url] > 1) {
                    return;
                }
                var fetchAction = {
                    type: 'API_FETCH',
                    meta: {
                        fetch: {
                            url: apiAction.request.url
                        }
                    }
                };
                next(fetchAction);
                return apiAction.fetch();
            }
            return apiAction;
        }
        return next(action);
    }; }; }];
//# sourceMappingURL=middleware.js.map