import * as models from './models';
export declare type UserStore = {
    [id: string]: models.UserModel | string;
    current?: string;
};
export declare type TeamStore = {
    [id: string]: models.TeamModel;
};
export declare type TeamInvitationStore = {
    [id: string]: models.TeamInvitationModel;
};
export declare type TournamentStore = {
    [id: string]: models.TournamentModel;
};
export declare type TournamentEntryStore = {
    [id: string]: models.TournamentEntryModel;
};
export declare type TournamentStageStore = {
    [id: string]: models.TournamentStageModel;
};
export declare type GameStore = {
    [id: string]: models.GameModel | string;
};
export declare type MatchStore = {
    [id: string]: models.MatchModel | string;
};
export declare type SeriesStore = {
    [id: string]: models.SeriesModel | string;
};
export declare type OpponentStore = {
    [id: string]: models.OpponentModel | string;
};
export declare type ArticleStore = {
    [id: string]: models.ArticleModel;
};
export declare type SeasonStore = {
    [id: string]: models.SeasonModel;
};
export declare type EventStore = {
    [id: string]: models.EventModel;
};
export declare type TourneyState = {
    users: UserStore;
    teams: TeamStore;
    team_invitations: TeamInvitationStore;
    tournaments: TournamentStore;
    tournament_entries: TournamentEntryStore;
    tournament_stages: TournamentStageStore;
    games: GameStore;
    matches: MatchStore;
    series: SeriesStore;
    opponents: OpponentStore;
    articles: ArticleStore;
    seasons: SeasonStore;
    events: EventStore;
    requests: any;
    queries: any;
};
export declare const DefaultState: TourneyState;
export declare function reducer(state: TourneyState, action: any): Object;
