"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _ = require("lodash");
var normalizr_1 = require("normalizr");
var actions = require("./actions");
var schemas = require("./schemas");
exports.DefaultState = {
    users: {},
    teams: {},
    team_invitations: {},
    tournaments: {},
    tournament_entries: {},
    tournament_stages: {},
    games: {},
    matches: {},
    series: {},
    opponents: {},
    articles: {},
    seasons: {},
    events: {},
    requests: {},
    queries: {}
};
function mergeState(state, newState) {
    return Object.assign({}, _.mergeWith(state, newState, function (objValue, srcValue) {
        if (_.isArray(objValue)) {
            return srcValue;
        }
    }));
}
function reducer(state, action) {
    if (state === void 0) { state = exports.DefaultState; }
    var newState;
    if (action.meta) {
        if (action.meta.fetch && action.meta.fetch.url) {
            state = __assign({}, state, { requests: __assign({}, state.requests, (_a = {}, _a[action.meta.fetch.url] = state.requests[action.meta.fetch.url] + 1 || 1, _a)) });
        }
        if (action.meta.fetch.done) {
            state = __assign({}, state);
            var url = new URL(action.meta.fetch.url);
            // searchParams will currently throw an error, fixed here:
            // https://github.com/Microsoft/TSJS-lib-generator/pull/198
            if ('searchParams' in HTMLAnchorElement.prototype) {
                var cacheKey = url.searchParams.get('cache');
                if (cacheKey && cacheKey !== '') {
                    state.queries[cacheKey] = action.payload;
                    if (action.payload.data instanceof Array) {
                        state.queries[cacheKey].idMap = action.payload.data.map(function (o) { return o.id; });
                    }
                }
            }
            delete state.requests[action.meta.fetch.url];
        }
    }
    switch (action.type) {
        case actions.AUTH_USER:
            var normalized = normalizr_1.normalize(action.payload, schemas.UserSchema).entities;
            normalized.users.current = action.payload.id;
            return mergeState(state, normalized);
        case actions.UPDATE_USERS:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.UserSchema]).entities);
        case actions.LOGOUT_USER:
            newState = __assign({}, state);
            delete newState.users.current;
            return newState;
        case actions.UPDATE_TEAMS:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.TeamSchema]).entities);
        case actions.UPDATE_TOURNAMENTS:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.TournamentSchema]).entities);
        case actions.UPDATE_TOURNAMENT_ENTRIES:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.TournamentEntrySchema]).entities);
        case actions.UPDATE_TEAM_INVITATIONS:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.TeamInvitationSchema]).entities);
        case actions.UPDATE_GAMES:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.GameSchema]).entities);
        case actions.UPDATE_MATCHES:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.MatchSchema]).entities);
        case actions.UPDATE_EVENTS:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.EventSchema]).entities);
        case actions.DELETE_EVENT:
            newState = mergeState(state, normalizr_1.normalize(action.payload, [schemas.EventSchema]).entities);
            delete newState.events[action.payload.id];
            return newState;
        case actions.UPDATE_SERIES:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.SeriesSchema]).entities);
        case actions.UPDATE_ARTICLES:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.ArticleSchema]).entities);
        case actions.DELETE_ARTICLE:
            newState = mergeState(state, normalizr_1.normalize(action.payload, [schemas.ArticleSchema]).entities);
            delete newState.articles[action.payload.id];
            return newState;
        case actions.UPDATE_SEASONS:
            return mergeState(state, normalizr_1.normalize(action.payload, [schemas.SeasonSchema]).entities);
        // Why merge the response?
        // we expect the deleted invitation in the response, which includes updated
        // associations for team_id and team that we want to merge into the state.
        case actions.DELETE_TEAM_INVITATIONS:
            newState = mergeState(state, normalizr_1.normalize(action.payload, [schemas.TeamInvitationSchema]).entities);
            action.payload.map(function (invitation) {
                return delete newState.team_invitations[invitation.id];
            });
            return newState;
        case actions.DELETE_TOURNAMENT_ENTRIES:
            newState = mergeState(state, normalizr_1.normalize(action.payload, [schemas.TournamentEntrySchema]).entities);
            action.payload.map(function (entry) {
                return delete newState.tournament_entries[entry.id];
            });
            return newState;
        default:
            return state;
    }
    var _a;
}
exports.reducer = reducer;
//# sourceMappingURL=reducer.js.map