"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var normalizr_1 = require("normalizr");
var TeamInvitation = require("../actions/teamInvitation");
var schemas_1 = require("../schemas");
function normalizeTeamInvitations(entries) {
    var normalized = normalizr_1.normalize(entries, [schemas_1.TeamInvitationSchema]);
    return normalized.entities.team_invitations;
}
function teamInvitations(state, action) {
    if (state === void 0) { state = {}; }
    switch (action.type) {
        case TeamInvitation.UPDATE_TEAM_INVITATIONS:
            return Object.assign({}, state, normalizeTeamInvitations(action.payload));
        default:
            return state;
    }
}
exports.teamInvitations = teamInvitations;
//# sourceMappingURL=teamInvitation.js.map