"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
// For more information about `relationshipStrategy`, see RFC #1:
// https://git-aws.internal.justin.tv/esports/tourney-sdk-react/issues/19
var lodash_1 = require("lodash");
var normalizr_1 = require("normalizr");
var api_1 = require("./api");
var config_1 = require("./config");
// If we have an ID map, but no objects, merge the map into the relation key
// and let the relationshipStrategy callback decide what to load.
function mergeIds(object, relationKey, idsKey) {
    if (object[relationKey] === undefined && object[idsKey] !== undefined) {
        object[relationKey] = object[idsKey];
        return object[idsKey].length > 0 ? true : false;
    }
    return false;
}
exports.mergeIds = mergeIds;
function relationshipStrategy(mapping, loadMissing) {
    var _this = this;
    return function (value, parent, key) {
        var result = __assign({}, value);
        var missing = [];
        for (var _i = 0, _a = Object.keys(mapping); _i < _a.length; _i++) {
            var relationKey = _a[_i];
            if (mergeIds(result, relationKey, mapping[relationKey])) {
                missing.push(relationKey);
            }
        }
        loadMissing.call(_this, result, missing);
        return result;
    };
}
exports.relationshipStrategy = relationshipStrategy;
function fetchMissing(entitySchema, object, relation) {
    var dispatch = config_1.config.store.dispatch;
    // TODO We'll need this for now. Don't try to clean up side effects, but
    // focus on implementing an approach that doesn't require them.
    setTimeout(function () {
        switch (entitySchema) {
            case TeamSchema: return dispatch(api_1.getTeam(object.id));
            // case UserSchema: return dispatch(getUser(object.id));
            case TournamentSchema: return dispatch(api_1.getTournament(object.id));
            case OpponentSchema: return; // no api point here
            default:
        }
        switch (relation) {
            case 'users':
                for (var _i = 0, _a = object[relation]; _i < _a.length; _i++) {
                    var userId = _a[_i];
                    dispatch(api_1.getUser(userId));
                }
                break;
            case 'tournament_entries':
                dispatch(api_1.getTournamentEntries({ ids: object[relation] }));
                break;
            case 'stages':
                dispatch(api_1.getTournament(object.id));
                break;
            case 'team_invitations':
                break;
            default:
                return true;
        }
    });
}
exports.fetchMissing = fetchMissing;
function checkMissing(entitySchema, object, relations) {
    return __awaiter(this, void 0, void 0, function () {
        var inflated, _i, relations_1, relation;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!(relations.length > 0)) return [3 /*break*/, 4];
                    inflated = normalizr_1.denormalize(object, entitySchema, config_1.config.store.getState().tourney);
                    _i = 0, relations_1 = relations;
                    _a.label = 1;
                case 1:
                    if (!(_i < relations_1.length)) return [3 /*break*/, 4];
                    relation = relations_1[_i];
                    if (!(inflated[relation] === undefined ||
                        (lodash_1.isArray(inflated[relation]) && inflated[relation].indexOf(undefined) !== -1))) return [3 /*break*/, 3];
                    return [4 /*yield*/, fetchMissing(entitySchema, object, relation)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/];
            }
        });
    });
}
var TeamSchema = new normalizr_1.schema.Entity('teams', {}, {
    processStrategy: relationshipStrategy({
        tournament_entries: 'tournament_entry_ids',
        team_invitations: 'team_invitation_ids'
        // users: 'user_ids'
    }, function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return checkMissing.call.apply(checkMissing, [undefined, _this.TeamSchema].concat(args));
    })
});
exports.TeamSchema = TeamSchema;
var TournamentEntrySchema = new normalizr_1.schema.Entity('tournament_entries', {}, {
    processStrategy: relationshipStrategy({
        tournament: 'tournament_id',
        entrant: 'entrant_id'
    }, function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return checkMissing.call.apply(checkMissing, [undefined, _this.TournamentEntrySchema].concat(args));
    })
});
exports.TournamentEntrySchema = TournamentEntrySchema;
var UserSchema = new normalizr_1.schema.Entity('users', {}, {
    processStrategy: relationshipStrategy({
        teams: 'team_ids'
    }, function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return checkMissing.call.apply(checkMissing, [undefined, _this.UserSchema].concat(args));
    })
});
exports.UserSchema = UserSchema;
var TournamentSchema = new normalizr_1.schema.Entity('tournaments', {}, {
    processStrategy: relationshipStrategy({
        game: 'game_id',
        tournament_entries: 'tournament_entry_ids',
        stages: 'stage_ids'
    }, function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return checkMissing.call.apply(checkMissing, [undefined, _this.TournamentSchema].concat(args));
    })
});
exports.TournamentSchema = TournamentSchema;
var TeamInvitationSchema = new normalizr_1.schema.Entity('team_invitations');
exports.TeamInvitationSchema = TeamInvitationSchema;
var TournamentStageSchema = new normalizr_1.schema.Entity('tournament_stages');
exports.TournamentStageSchema = TournamentStageSchema;
var GameSchema = new normalizr_1.schema.Entity('games');
exports.GameSchema = GameSchema;
var EventSchema = new normalizr_1.schema.Entity('events');
exports.EventSchema = EventSchema;
var MatchSchema = new normalizr_1.schema.Entity('matches', {});
exports.MatchSchema = MatchSchema;
var SeriesSchema = new normalizr_1.schema.Entity('series', {});
exports.SeriesSchema = SeriesSchema;
var ArticleSchema = new normalizr_1.schema.Entity('articles', {});
exports.ArticleSchema = ArticleSchema;
var SeasonSchema = new normalizr_1.schema.Entity('season', {});
exports.SeasonSchema = SeasonSchema;
var OpponentSchema = new normalizr_1.schema.Entity('opponents', {}, {
    processStrategy: function (value, parent, key) {
        // TODO: Remove this once we have unions normalizing from api correctly.
        return __assign({}, value, { contender: {
                id: value.contender_id,
                schema: value.contender_type === 'Team' ? 'team' : 'user'
            } });
    }
});
exports.OpponentSchema = OpponentSchema;
TeamSchema.define({
    tournament_entries: [TournamentEntrySchema],
    team_invitations: [TeamInvitationSchema],
    users: [UserSchema]
});
TeamInvitationSchema.define({
    team: TeamSchema
});
var UnionSchema = new normalizr_1.schema.Union({
    team: TeamSchema,
    user: UserSchema
}, function (value, parent, key) {
    return parent.entrant_type;
});
TournamentEntrySchema.define({
    tournament: TournamentSchema,
    entrant: TeamSchema
});
TournamentSchema.define({
    tournament_entries: [TournamentEntrySchema],
    stages: [TournamentStageSchema],
    game: GameSchema
});
UserSchema.define({
    teams: [TeamSchema]
});
GameSchema.define({
    tournaments: [TournamentSchema]
});
MatchSchema.define({
    game: GameSchema,
    winner: TeamSchema,
    opponents: [OpponentSchema]
});
SeriesSchema.define({
    matches: [MatchSchema],
    opponents: [OpponentSchema]
});
ArticleSchema.define({
    author: UserSchema
});
SeasonSchema.define({
    tournaments: [TournamentSchema]
});
var ContestSchema = new normalizr_1.schema.Union({
    match: MatchSchema,
    series: SeriesSchema
}, function (value, parent, key) { return parent.contest_type; });
// since we are are not normalizing this through SDK,
// unionAttribute key doesn't matter, it doesn't use it on denormalize.
var ContenderSchema = new normalizr_1.schema.Union({
    team: TeamSchema,
    user: UserSchema
}, 'unused_variable');
OpponentSchema.define({
    contest: ContestSchema,
    contender: ContenderSchema
});
//# sourceMappingURL=schemas.js.map