import { Action } from '../actions';
import { ArticleModel } from '../models';

export const UPDATE_ARTICLES = 'UPDATE_ARTICLES';
export interface UpdateArticlesAction extends Action<typeof UPDATE_ARTICLES, ArticleModel[]> {}
export function createUpdateArticlesAction(articles: ArticleModel[]): UpdateArticlesAction {
  return {
    type: UPDATE_ARTICLES,
    payload: articles
  };
}

export const DELETE_ARTICLE = 'DELETE_ARTICLE';
export interface DeleteArticleAction extends Action<typeof DELETE_ARTICLE, ArticleModel> {}
export function createDeleteArticleAction(article: ArticleModel): DeleteArticleAction {
  return {
    type: DELETE_ARTICLE,
    payload: article
  };
}

export type ArticleActions = UpdateArticlesAction | DeleteArticleAction;
