import { Action } from '../actions';
import { EventModel } from '../models';

export const UPDATE_EVENTS = 'UPDATE_EVENTS';
export interface UpdateEventsAction extends Action<typeof UPDATE_EVENTS, EventModel[]> {}
export function createUpdateEventsAction(events: EventModel[]): UpdateEventsAction {
  return {
    type: UPDATE_EVENTS,
    payload: events
  };
}

export const DELETE_EVENT = 'DELETE_EVENT';
export interface DeleteEventAction extends Action<typeof DELETE_EVENT, EventModel> {}
export function createDeleteEventAction(event: EventModel): DeleteEventAction {
  return {
    type: DELETE_EVENT,
    payload: event
  };
}

export type EventActions = UpdateEventsAction | DeleteEventAction;
