import { Action } from '../actions';
import { GameModel } from '../models';

export const UPDATE_GAMES = 'UPDATE_GAMES';

export interface UpdateGamesAction extends Action<typeof UPDATE_GAMES, GameModel[]> {}

export function createUpdateGamesAction(games: GameModel[]): UpdateGamesAction {
  return {
    type: UPDATE_GAMES,
    payload: games
  };
}

export type GameActions = UpdateGamesAction;
