import { Action } from '../actions';
import { MatchModel } from '../models';

export const UPDATE_MATCHES = 'UPDATE_MATCHES';

export interface UpdateMatchesAction extends Action<typeof UPDATE_MATCHES, MatchModel[]> {}

export function createUpdateMatchesAction(matches: MatchModel[]): UpdateMatchesAction {
  return {
    type: UPDATE_MATCHES,
    payload: matches
  };
}

export type MatchActions = UpdateMatchesAction;
