import { Action } from '../actions';
import { EventModel, SeriesModel } from '../models';

export const UPDATE_SCHEDULE = 'UPDATE_SCHEDULE';
export interface UpdateScheduleAction extends Action<typeof UPDATE_SCHEDULE, (EventModel|SeriesModel)[]> {}
export function createUpdateScheduleAction(scheduledEvents: (EventModel|SeriesModel)[]): UpdateScheduleAction {
  return {
    type: UPDATE_SCHEDULE,
    payload: scheduledEvents
  };
}

export type ScheduleActions = UpdateScheduleAction;
