import { Action } from '../actions';
import { SeasonModel } from '../models';

export const UPDATE_SEASONS = 'UPDATE_SEASONS';

export interface UpdateSeasonsAction extends Action<typeof UPDATE_SEASONS, SeasonModel[]> {}

export function createUpdateSeasonsAction(seasons: SeasonModel[]): UpdateSeasonsAction {
  return {
    type: UPDATE_SEASONS,
    payload: seasons
  };
}

export type SeasonActions = UpdateSeasonsAction;
