import { Action } from '../actions';
import { SeriesModel } from '../models';

export const UPDATE_SERIES = 'UPDATE_SERIES';

export interface UpdateSeriesAction extends Action<typeof UPDATE_SERIES, SeriesModel[]> {}

export function createUpdateSeriesAction(series: SeriesModel[]): UpdateSeriesAction {
  return {
    type: UPDATE_SERIES,
    payload: series
  };
}

export type SeriesActions = UpdateSeriesAction;
