import { Action } from '../actions';
import { TeamModel } from '../models';

export const UPDATE_TEAMS = 'UPDATE_TEAMS';

export interface UpdateTeamsAction extends Action<typeof UPDATE_TEAMS, TeamModel[]> {}

export function createUpdateTeamsAction(teams: TeamModel[]): UpdateTeamsAction {
  return {
    type: UPDATE_TEAMS,
    payload: teams
  };
}

export type TeamActions = UpdateTeamsAction;
