import { Action } from '../actions';
import { TeamInvitationModel } from '../models';

export const UPDATE_TEAM_INVITATIONS = 'UPDATE_TEAM_INVITATIONS';
export const DELETE_TEAM_INVITATIONS = 'DELETE_TEAM_INVITATIONS';

export interface UpdateTeamInvitationsAction extends
  Action<typeof UPDATE_TEAM_INVITATIONS, TeamInvitationModel[]> {}

export interface DeleteTeamInvitationsAction extends
  Action<typeof DELETE_TEAM_INVITATIONS, TeamInvitationModel[]> {}

export function createUpdateTeamInvitationsAction(teamInvitations: TeamInvitationModel[]):
  UpdateTeamInvitationsAction {
  return {
    type: UPDATE_TEAM_INVITATIONS,
    payload: teamInvitations
  };
}

export function createDeleteTeamInvitationsAction(teamInvitations: TeamInvitationModel[]):
  DeleteTeamInvitationsAction {
  return {
    type: DELETE_TEAM_INVITATIONS,
    payload: teamInvitations
  };
}

export type TeamInvitationActions = UpdateTeamInvitationsAction |
  DeleteTeamInvitationsAction;
