import { Action } from '../actions';
import { TournamentModel } from '../models';

export const UPDATE_TOURNAMENTS = 'UPDATE_TOURNAMENTS';

export interface UpdateTournamentsAction extends Action<typeof UPDATE_TOURNAMENTS, TournamentModel[]> {}

export function createUpdateTournamentsAction(tournaments: TournamentModel[]): UpdateTournamentsAction {
  return {
    type: UPDATE_TOURNAMENTS,
    payload: tournaments
  };
}

export type TournamentActions = UpdateTournamentsAction;
